<?php

function lang($key)
{
    $lang = [
        'text_title' => 'TastyIgniter - %s',
        'text_setup' => 'Setup',
        'text_installation' => 'Setup Wizard',
        'text_license_heading' => 'License agreement',
        'text_requirement_heading' => 'Server Requirements',
        'text_database_heading' => 'Database Settings',
        'text_settings_heading' => 'Application Setup',
        'text_complete_heading' => 'Setup your site',
        'text_success_heading' => 'Installation Successful',

        'text_license_sub_heading' => 'TastyIgniter End User Licence agreement (EULA).',
        'text_requirement_sub_heading' => 'Check below to make sure all system requirements are met.',
        'text_database_sub_heading' => 'Enter your database connection details.',
        'text_settings_sub_heading' => 'Enter your administrator and restaurant details.',
        'text_complete_sub_heading' => 'How do you want to set up your site?',
        'text_success_sub_heading' => 'Start receiving orders!',

        'text_php_version' => '- PHP version '.TI_PHP_VERSION.' or greater required',
        'text_mysql_version' => 'MySQL version '.TI_MYSQL_VERSION.' or greater required',
        'text_mysqli_installed' => '- is MySQLi PHP Extension installed?',
        'text_curl_installed' => '- cURL PHP Extension is required',
        'text_live_connection' => '- Test connection to the installation server is required',
        'text_pdo_installed' => '- PDO PHP Extension is required',
        'text_mbstring_installed' => '- Mbstring PHP Extension is required',
        'text_ssl_installed' => '- OpenSSL PHP Extension is required',
        'text_zip_installed' => '- ZipArchive PHP Library is required',
        'text_gd_installed' => '- GD PHP Library is required',
        'text_register_globals_enabled' => '- is Register Globals turned off?',
        'text_magic_quotes_enabled' => '- is Magic Quotes GPC turned off?',
        'text_file_uploads_enabled' => '- is File Uploads turned on?',
        'text_is_file_writable' => '- is directories & files writable?',
        'text_is_foundation' => '- is foundation libraries available?',

        'text_license_agreed' => 'By proceeding further, you will be deemed to have accepted the License agreement.',
        'text_login_to_admin' => 'Login to Your Admin Dashboard',
        'text_goto_storefront' => 'View Your Online Restaurant',
        'text_next_step' => 'Next Step:',
        'text_restaurant_details' => 'Restaurant settings',
        'text_admin_details' => 'Administrator details',
        'text_installation_success' => 'TastyIgniter has been installed successfully.',
        'text_join_community' => '<h3>Join the community</h3><span>Receive future updates, recent news and free support.</span>',

        'text_tastyigniter_home' => 'TastyIgniter Homepage',
        'text_documentation' => 'Documentation',
        'text_community_forums' => 'Community Forums',
        'text_feature_request' => 'Feature Requests',

        'text_single_location' => 'Single Location',
        'text_multi_location' => 'Multiple Locations',
        'text_no' => 'NO',
        'text_yes' => 'YES',
        'text_whats_this' => 'What is this?',
        'text_fetch_extensions' => 'Fetching extensions from the TastyIgniter Marketplace...',

        'label_requirement' => 'Requirement Field',
        'label_php_version' => 'PHP Version (required '.TI_PHP_VERSION.'+)',
        'label_register_globals' => 'Register Globals',
        'label_magic_quotes' => 'Magic Quotes GPC',
        'label_file_uploads' => 'File Uploads',
        'label_mysqli' => 'MySQLi PHP Extension',
        'label_pdo' => 'PDO PHP Extension',
        'label_curl' => 'cURL PHP Extension',
        'label_connection' => 'Live Connection',
        'label_mbstring' => 'Mbstring PHP Extension',
        'label_ssl' => 'OpenSSL PHP Extension',
        'label_gd' => 'GD PHP Library',
        'label_zip' => 'ZipArchive PHP Library',
        'label_writable' => 'Permission to write to directories and files',
        'label_foundation' => 'Foundation Libraries',

        'label_database' => 'Database Name',
        'label_hostname' => 'Hostname',
        'label_port' => 'Port',
        'label_username' => 'Username',
        'label_password' => 'Password',
        'label_prefix' => 'Table Prefix',

        'label_site_location_mode' => 'Enable single location mode',
        'label_site_name' => 'Restaurant name',
        'label_site_email' => 'Restaurant email',
        'label_staff_name' => 'Full name',
        'label_admin_username' => 'Username',
        'label_admin_password' => 'Password',
        'label_confirm_password' => 'Confirm password',
        'label_demo_data' => 'Install demo data',

        'label_site_key' => 'Attach your Site Carté Key... (Optional)',
        'label_extensions' => 'Popular Extensions',
        'label_meta_data' => 'Meta Data',

        'help_database' => 'Enter the name of the database you want to use.',
        'help_hostname' => 'Enter the database host name.',
        'help_username' => 'Enter the database username.',
        'help_password' => 'Enter the database password.',
        'help_dbprefix' => 'The database table prefix. Do not change unless you have to.',
        'help_site_location_mode' => 'You can change this setting later under the System General Settings',
        'help_extensions' => 'Enjoy TastyIgniter extended core features with these extensions',
        'help_site_key' => 'A Site Carté key is required to add/update item from the TastyIgniter Marketplace. Get one by creating a site from your <a href="%s" target="_blank">TastyIgniter Account</a>, if you haven\'t already.',

        'button_continue' => 'Continue',
        'button_proceed' => 'Complete setup',
        'button_back' => 'Start Over',
        'button_skip' => 'Skip',
        'button_cancel' => 'Cancel',
        'button_database' => 'Database Settings',
        'button_admin' => 'Application Setup',
        'button_install' => 'Setup your Site',
        'button_accept' => 'Accept license',
        'button_clean_install' => 'Fresh: No theme or extensions',
        'button_choose_theme' => 'Install with a pre-built theme',

        'alert_license_error' => 'Please accept the TastyIgniter license before proceeding.',
        'alert_requirement_error' => 'Error checking server requirements, please make sure all lights are green.',
        'alert_database_error' => 'Database connection was not successful, please make sure the database server, username and password is correct.',
        'alert_settings_error' => 'Error installing user and site settings.',
        'alert_complete_error' => 'Missing addons are missing.',
    ];

    return isset($lang[$key]) ? $lang[$key] : null;
}
